using log4net;
using Microsoft.Azure.WebJobs;
using System;
using System.Threading.Tasks;
using VA.PPMS.IWS.Common;
using VA.PPMS.IWS.CreateResponseService.Interface;
using VA.PPMS.IWS.Functions.Configuration.Interface;

namespace VA.PPMS.IWS.Functions
{
    public static class InitiateResponseQueueTrigger
    {
        [FunctionName("InitiateResponseQueueTrigger")]
        public static async Task Run([QueueTrigger("%CrInitiateQueue%", Connection = "AzureWebJobsStorage")]string responseQueueItem,
            [Inject] IIwsConfiguration configuration,
            [Inject] ICreateResponseService createResponseService,
            [Inject] ILog logger)
        {
            try
            {
                logger.Info($"Start InitiateResponseQueueTrigger function");

                var transactionId = Guid.NewGuid().ToString();
                var dasMessage = new DasMessage(string.Empty, await configuration.GetPpmsDasIdentifierAsync(), string.Empty, transactionId, responseQueueItem);

                await createResponseService.NotifyOfResponse(dasMessage);

                logger.Info($"@@@@ INFO - End Send -- CreateResponse @@@@");

                logger.Info($"End InitiateResponseQueueTrigger function");
            }
            catch (Exception ex)
            {
                logger.Error($"There was a problem with InitiateResponseQueueTrigger", ex);
            }
        }
    }
}